/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;

public class DevOptions {
    public static final transient int VERSION_VAL = 14;
    public static final transient String VERSION_KEY = "VERSION";
    public static final transient String PROPS_FILENAME = "development.properties";
    private static transient boolean verbose;
    public static transient boolean loaded;
    public static transient boolean devMode;
    public static boolean openOverlayAdjustmentDialog;
    public static boolean showTimingInfo;
    public static boolean showDevMenuItems;
    public static boolean monitorPSG;
    public static boolean useAntiAliasingInDebugTools;
    public static boolean disableGLContextSharing;
    public static boolean adjustLightpenHitzone;
    public static boolean debugLightpenHitzone;
    public static boolean useLightpenStillnessTimer;
    public static boolean showUsedMemoryFPS;
    public static boolean ignoreFrameCyclesOverrun;
    public static boolean monitorDeadlocks;
    public static boolean automaticCartridgeRAM;
    public static boolean alwaysEmulateFIRQ;

    private DevOptions() {
    }

    public static void ensureLoaded() {
        if (!loaded) {
            DevOptions.load(new File("data", PROPS_FILENAME), false);
        }
    }

    public static synchronized void load(File file, boolean bl) {
        boolean bl2;
        String string;
        block21: {
            loaded = true;
            verbose = bl;
            string = Utils.getRelativePath(file);
            bl2 = false;
            InputStream inputStream = null;
            try {
                try {
                    if (file.isFile()) {
                        System.out.println("Loading development properties [" + string + "]");
                        inputStream = new FileInputStream(file);
                        bl2 = DevOptions.load(inputStream);
                        if (bl2 && bl) {
                            System.out.println("Warning : dev properties file version mismatch, updating content in [" + string + "]");
                        }
                    } else {
                        if (bl) {
                            System.out.println("Warning : no dev properties file found, creating one with defaults at [" + string + "]");
                        }
                        bl2 = true;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Warning: Exception while loading dev-mode properties (" + string + ")");
                    exception.printStackTrace(System.err);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (bl2) {
            try {
                DevOptions.save(file);
            }
            catch (Exception exception) {
                System.err.println("Warning: Exception while saving dev-mode properties (" + string + ")");
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void save(File file) {
        block14: {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    DevOptions.save(fileOutputStream);
                }
                catch (Exception exception) {
                    System.err.println("Warning: Exception while saving dev-mode properties (" + file.getPath() + ")");
                    exception.printStackTrace(System.err);
                    if (fileOutputStream != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean load(InputStream var0) throws Exception {
        var1_1 = DevOptions.class.getDeclaredFields();
        var2_2 = new Properties();
        var2_2.load(var0);
        var6_3 = var1_1;
        var5_4 = var1_1.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block5: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                var3_7 = var6_3[var4_5];
                                if (Modifier.isTransient(var3_7.getModifiers()) || (var8_9 = var2_2.getProperty(var7_8 = var3_7.getName())) == null || "".equals(var8_9)) break block5;
                                var9_10 = null;
                                var10_11 = var3_7.getType();
                                if (!var10_11.equals(String.class)) break block6;
                                var9_10 = var8_9;
                                ** GOTO lbl32
                            }
                            if (!var10_11.equals(Boolean.TYPE)) break block7;
                            var9_10 = Boolean.valueOf(var8_9);
                            ** GOTO lbl32
                        }
                        if (!var10_11.equals(Integer.TYPE)) break block8;
                        var9_10 = new Integer(var8_9);
                        ** GOTO lbl32
                    }
                    if (!var10_11.equals(Float.TYPE)) break block9;
                    var9_10 = new Float(var8_9);
                    ** GOTO lbl32
                }
                if (!var10_11.equals(Double.TYPE)) {
                    System.err.println("Warning: Unknown type [" + var10_11 + "] for development property \"" + var7_8 + "\"");
                } else {
                    var9_10 = new Double(var8_9);
lbl32:
                    // 5 sources

                    if (DevOptions.verbose) {
                        System.out.println("* " + var7_8 + " <-- " + var9_10.toString());
                    }
                    var3_7.set(null, var9_10);
                }
            }
            ++var4_5;
        }
        if (DevOptions.verbose) {
            System.out.println("");
        }
        var3_7 = var2_2.getProperty("VERSION");
        var4_6 = Integer.toString(14);
        return var4_6.equals(var3_7) == false;
    }

    private static void save(OutputStream outputStream) throws Exception {
        Field[] fieldArray;
        Properties properties = new Properties();
        Field[] fieldArray2 = fieldArray = DevOptions.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (!Modifier.isTransient(field.getModifiers())) {
                Object object = field.get(null);
                properties.put(field.getName(), object == null ? "" : object.toString());
            }
            ++n2;
        }
        properties.put(VERSION_KEY, Integer.toString(14));
        properties.store(outputStream, " ParaJVE's development properties - Not to be edited manually");
    }
}

